<?php
/*
 +-------------------------------------------------------------------------+
 | Copyright (C) 2022-2024 The Cacti Group, Inc.                           |
 |                                                                         |
 | Based on the Original Plugin developed by Howard Jones                  |
 |                                                                         |
 | Copyright (C) 2005-2022 Howard Jones and contributors                   |
 |                                                                         |
 | Permission is hereby granted, free of charge, to any person obtaining   |
 | a copy of this software and associated documentation files              |
 | (the "Software"), to deal in the Software without restriction,          |
 | including without limitation the rights to use, copy, modify, merge,    |
 | publish, distribute, sublicense, and/or sell copies of the Software,    |
 | and to permit persons to whom the Software is furnished to do so,       |
 | subject to the following conditions:                                    |
 |                                                                         |
 | The above copyright notice and this permission notice shall be          |
 | included in all copies or substantial portions of the Software.         |
 |                                                                         |
 | THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,         |
 | EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES         |
 | OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND                |
 | NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS     |
 | BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN      |
 | ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN       |
 | CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE        |
 | SOFTWARE.                                                               |
 +-------------------------------------------------------------------------+
 | Cacti: The Complete RRDtool-based Graphing Solution                     |
 +-------------------------------------------------------------------------+
 | Extensions to Howard Jones' original work are designed, written, and    |
 | maintained by the Cacti Group.                                          |
 |                                                                         |
 | Howard Jones was the original author of Weathermap.  You can reach      |
 | him at: howie@thingy.com                                                |
 +-------------------------------------------------------------------------+
 | http://www.network-weathermap.com/                                      |
 | http://www.cacti.net/                                                   |
 +-------------------------------------------------------------------------+
*/

chdir('../../../');
include_once('./include/cli_check.php');

$target_format  = '';
$infourl_format = '';
$overlib_format = '';

#
# change these three and then run this.
# run the result through cacti-integrate to fill in the TARGETS etc.
#   Change the

$switchname = 'sw1';
$nports = 48;
$cacti_host_id = 17;
$interfacepattern = 'Gi0/%d';

printf("# generated by bristle.php - %d ports\n# First, the actual switch node. Give this an ICON\nNODE %s\n\tPOSITION 400 400\n\n", $nports, $switchname);

for($n=1; $n<=$nports; $n++) {
    $nodename = sprintf('%s_p%d', $switchname, $n);
    $linkname = sprintf('%s_%s', $switchname, $nodename);

    $halfway = $nports/2; // the midpoint of a side
    $quarter = $halfway/2; // the midpoint of a side
    $voffset = 40; // the length of the bristle
    $voffset2 = 13; // the inside offset of the bristle

    if ($n > $halfway) {
        $offset = ($n - 24  - 1 - $quarter)*8;
    } else {
        // The first 24 ports grow up instead of down
        $offset = ($n - 1 - $quarter)*8;
        $voffset = -$voffset;
        $voffset2 = -$voffset2;
    }

	$target     = 'tgt?';
	$infourl    = 'info?';
	$overliburl = 'over?';

	printf("NODE %s\n\tPOSITION %s %d %d\n\tSET cacti_id %d\n\n", $nodename,$switchname,$offset,$voffset, $cacti_host_id);

	printf("LINK %s\n\tNODES %s:%d:%d %s\n\tBWLABEL none\n\tWIDTH 2\n\tARROWSTYLE compact\n\tOUTLINECOLOR none\n", $linkname, $switchname, $offset, $voffset2, $nodename);

	$interfacename = sprintf($interfacepattern,$n);

	print "\tSET out_interface $interfacename";

	# printf("\tINFOURL %s\n\tOVERLIBGRAPH %s\n\tTARGET %s\n", $infourl, $overliburl, $target );
	print "\n\n";
}

print "# Now run this output through cacti-integrate.php to add all the INFOURL and TARGET lines";

